<?php
include("../../common/access.php");
include("../../common/autoload.php");

if(!$_GET['action'])
{
	$_GET['action']='invoice';
}

if($_GET['id'])
{
	$_GET['id']=decrypt($_GET['id']);
}
 
if($_GET['del_id'])
{
	$_GET['del_id']=decrypt($_GET['del_id']);
}

$data['breadcrumb']=[];
$data['page_title']="Invoice";
 

switch($_GET['action'])
{
	case "view-invoice":
	case "invoice-list":
	    $query=array("office_id"=>$_SESSION['office_id']);
	    
	    if($_GET['client_id'])
	    {
	       $query=array_merge($query,array("client_id"=>$_GET['client_id']));	
	    }	
	    if($_POST['client_id'])
	    {
	       $query=array_merge($query,array("client_id"=>$_POST['client_id']));	
	    }	
	    if($_POST['search'])
	    {
	       $query=array_merge($query,array("id"=>$_POST['search']));	
	    } 
	    
		$data['page_subtitle']="View Invoice";

		$data['breadcrumb']=array("Invoice"=>"");
		$data['btn']="<a href='add-invoice' class='btn btn-success pull-right'><i class='fa fa-plus'></i> Add New invoice</a>";
		
		$data['total']=getTotalRow("bill",$query);
	    $data['db_list']=getQuery("bill","*",$query,"id desc",$configs['limit']);

	    if($_GET['del_id'])
		{

			$r=deleteData("bill",array("id"=>$_GET['del_id']));
		
			$data['msg']=$configs['delete_msg'];
		}
	
	break;

	case "add-invoice":
	
	    $data['clients']=getQuery("clients","*",array("pay_type"=>"credit"),"company_name");
	    
		$data['page_subtitle']="Add | Update invoice";

		$data['breadcrumb']=array("All Invoice"=>$configs['admin_vpath'] ."invoice/view-invoice","Add | Edit invoice"=>"");
		 
		if($_GET['id'])
		{
		   $data['db_value']= getDataByWhere('bill','*',array('id'=>$_GET['id']));
		}
	
	break;
	case "print":
	
        $query=array("b.office_id"=>$_SESSION['office_id']);
        
        if($_GET['id'])
		{
			$query=array_merge($query,array("b.id"=>$_GET['id']));
			
			$b=getDataByWhere("bill","*",array("id"=>$_GET['id']));
			
			
			$_GET['client_id']=$b['client_id'];
			
			$_GET['st_dt']=$b['st_dt'];
			$_GET['to_dt']=$b['to_dt'];
			$_GET['pod_id']=$b['pod_id'];
			$courier_no=getFldValueById("pod","courier_no",array("id"=>$b['pod_id']));
			$data['tracking_id']=$courier_no;
		}
		
		if($_GET['st_dt'] && $_GET['to_dt'])
		{
		    $query=array_merge($query,array("p.date>="=>"'".$_GET['st_dt']."'","p.date<="=>"'".$_GET['to_dt']."'"));
		    
		    $data['st_dt']=$_GET['st_dt'];
		    $data['to_dt']=$_GET['to_dt'];
		}
		else
		{
			$data['st_dt']=date("Y-m-d");
		    $data['to_dt']=date("Y-m-d");
			 
		}
		
				
		if($_GET['client_id'])
		{
			$query=array_merge($query,array("b.client_id"=>$_GET['client_id']));
		}
		if($_GET['courier_no'])
		{
			$query=array_merge($query,array("b.courier_no"=>$_GET['courier_no']));
		}
			
			    	
		$data['total']=getTotalRowsByJoin(array("bill as b","pod as p"),$query,array("b.pod_id"=>"p.id"));
		
		if(!$data['total'])
		{
		    $data['msg']="<font color=red>No data found!</font>";
		}
		else
		{
			$charge=0;$weight=0;
			    
			$data['db_list']=getQueryByJoin(array("bill as b","pod as p"),"b.*,p.*",$query,array("b.pod_id"=>"p.id"));	
			//echo getQueryByJoin(array("bill as b","pod as p"),"b.*,p.*",$query,array("b.pod_id"=>"p.id"),'','',1);
		}	
	
	    $data['invoice_date']=$b["invoice_date"];
	    
		$data['invoice_no']=$b["invoice_no"];
		
		if($_GET['client_id'])
		{
			$data['db_value']=getDataByWhere("clients","*",array("user_id"=>$_GET['client_id']));
			
		 
			$data['country_name']=getFldValueById("country","name",array("id"=>$configs['country_id']));
			$data['state_name']=getFldValueById("state","name",array("id"=>$data['db_value']['state_id']));
			$data['city_name']=getFldValueById("city","name",array("id"=>$data['db_value']['city_id']));
		}
		else
		{
			$data['db_value']=getDataByWhere("pod","*",array("id"=>$_GET['pod_id']));
			$data['db_value']['contact_name']=$data['db_value']['origin_contact'];
			 
			
			$data['country_name']=getFldValueById("country","name",array("id"=>$configs['country_id']));
			$data['state_name']=getFldValueById("state","name",array("id"=>$data['db_value']['origin_state_id']));
			$data['city_name']=getFldValueById("city","name",array("id"=>$data['db_value']['origin_city_id']));
			$data['db_value']['address']=$data['db_value']['origin_address'];
			$data['db_value']['zipcode']=$data['db_value']['origin_zipcode'];
			$data['db_value']['mobile']=$data['db_value']['origin_mobile'];
			$data['db_value']['gstn']=$data['db_value']['origin_gstn'];
	
		}	
		
        if($_SESSION['type']!="S")
        {
        	$office=getDataByWhere("offices","*",array("id"=>$_SESSION['office_id']));
        	  
        	$city=getFldValueById("city","name",array("id"=>$office['city_id']));
        	
        	$state=getFldValueById("state","name",array("id"=>$office['state_id']));
        	
        	$data['contact_details']="<b>".$office['office_name']."</b><br>" . $office['address'] ."," . $city . "," . $state ."," . $office['zipcode'] . "<br>Phone:".$offices['mobile'] .",Email:".$offices['email'] .",Web:www." .$configs['dotcom'] .",GST No :" .$office['gstn']; 
        }	

		unset($configs['includes']);
	break;	


}      
 
$data['action']=$_GET['action'];
echo template($data); 
?>
 

